/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CantTouchAnythingChallenge
extends Challenge {
    private static final String SETTING_FORBIDDEN_ITEMS = "forbidden_items";
    private static final String DEFAULT_FORBIDDEN_ITEMS = "";
    private final Set<UUID> killedPlayers = new HashSet<UUID>();

    public CantTouchAnythingChallenge() {
        super("cant_touch_anything", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_anything.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_anything.description"), true, Challenge.MultiplayerStatus.UNTESTED_MULTIPLAYER);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_FORBIDDEN_ITEMS)) {
            this.setForbiddenItems(DEFAULT_FORBIDDEN_ITEMS);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.killedPlayers.clear();
    }

    @Override
    public void onDisable() {
        this.killedPlayers.clear();
    }

    public String getForbiddenItems() {
        return ChallengeSettings.getStringOption(this.getId(), SETTING_FORBIDDEN_ITEMS, DEFAULT_FORBIDDEN_ITEMS);
    }

    public void setForbiddenItems(String items) {
        ChallengeSettings.setStringOption(this.getId(), SETTING_FORBIDDEN_ITEMS, items);
    }

    public boolean isForbidden(String id) {
        String[] forbiddenList;
        String forbiddenItems = this.getForbiddenItems();
        if (forbiddenItems.isEmpty()) {
            return false;
        }
        for (String forbidden : forbiddenList = forbiddenItems.split(",")) {
            String normalizedId;
            String normalizedForbidden = this.normalizeId(forbidden.trim());
            if (!normalizedForbidden.equalsIgnoreCase(normalizedId = this.normalizeId(id))) continue;
            return true;
        }
        return false;
    }

    private String normalizeId(String id) {
        if (id.contains(":")) {
            return id;
        }
        return "minecraft:" + id;
    }

    public boolean isForbiddenBlock(class_2248 block) {
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        return this.isForbidden(blockId);
    }

    public boolean isForbiddenItem(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return this.isForbidden(itemId);
    }

    public boolean isForbiddenMob(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        String entityId = class_7923.field_41177.method_10221((Object)entityType).toString();
        return this.isForbidden(entityId);
    }

    public void onPlayerTouchBlock(class_1657 player, class_1937 world, class_2338 pos, class_2248 block) {
        if (!this.isEnabled() || world.field_9236) {
            return;
        }
        if (this.isForbiddenBlock(block)) {
            this.killPlayer(player, "block", class_7923.field_41175.method_10221((Object)block).toString());
        }
    }

    public void onPlayerTouchItem(class_1657 player, class_1799 itemStack) {
        if (!this.isEnabled() || player.method_37908().field_9236) {
            return;
        }
        if (this.isForbiddenItem(itemStack.method_7909())) {
            this.killPlayer(player, "item", class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
        }
    }

    public void onPlayerTouchMob(class_1657 player, class_1297 entity) {
        if (!this.isEnabled() || player.method_37908().field_9236) {
            return;
        }
        if (this.isForbiddenMob(entity)) {
            this.killPlayer(player, "mob", class_7923.field_41177.method_10221((Object)entity.method_5864()).toString());
        }
    }

    public boolean shouldKillPlayer(class_1657 player) {
        if (!this.isEnabled()) {
            return false;
        }
        class_2338 pos = player.method_24515();
        for (int y = 0; y <= 1; ++y) {
            class_2338 checkPos = pos.method_10086(y);
            class_2248 block = player.method_37908().method_8320(checkPos).method_26204();
            if (!this.isForbiddenBlock(block)) continue;
            this.killPlayer(player, "block", class_7923.field_41175.method_10221((Object)block).toString());
            return true;
        }
        class_2338 standingPos = class_2338.method_49637((double)player.method_23317(), (double)(player.method_23318() - 0.1), (double)player.method_23321());
        class_2248 standingBlock = player.method_37908().method_8320(standingPos).method_26204();
        if (this.isForbiddenBlock(standingBlock)) {
            this.killPlayer(player, "block", class_7923.field_41175.method_10221((Object)standingBlock).toString());
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.isForbiddenItem(stack.method_7909())) continue;
            this.killPlayer(player, "item", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
            return true;
        }
        double checkRadius = 0.75;
        class_238 checkBox = player.method_5829().method_1014(checkRadius);
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, checkBox)) {
            if (!this.isForbiddenMob(entity)) continue;
            this.killPlayer(player, "mob", class_7923.field_41177.method_10221((Object)entity.method_5864()).toString());
            return true;
        }
        return false;
    }

    public void onAttackForbiddenMob(class_1657 player, class_1297 target) {
        if (this.isEnabled() && this.isForbiddenMob(target)) {
            this.killPlayer(player, "mob_attack", class_7923.field_41177.method_10221((Object)target.method_5864()).toString());
        }
    }

    private void killPlayer(class_1657 player, String deathType, String targetName) {
        class_1937 class_19372;
        if (this.killedPlayers.contains(player.method_5667())) {
            return;
        }
        this.killedPlayers.add(player.method_5667());
        if (player instanceof class_3222 && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            player.method_64397(serverWorld, serverWorld.method_48963().method_48831(), Float.MAX_VALUE);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.forbidden_touch." + deathType), (Object[])new Object[]{targetName}), true);
        } else {
            player.method_6033(0.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.forbidden_touch." + deathType), (Object[])new Object[]{targetName}), true);
        }
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                this.killedPlayers.remove(player.method_5667());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }
}

